/*
 *	spGL_Gtk.h
 */

#ifndef __SPGL_GTK_H
#define __SPGL_GTK_H

#if GTK_CHECK_VERSION(3,16,0)
#include <gdk/gdkglcontext.h>
#include <gtk/gtkglarea.h>
#else
#include <gdk/gdkgl.h>
#include <gtk/gtkgl.h>
#endif

#if !defined(SP_GL_USE_GTK_GL_AREA) || defined(GDK_WINDOWING_X11)
#include <GL/glx.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if GTK_CHECK_VERSION(3,16,0)
#define SP_GL_USE_GTK_GL_AREA
#else
#undef SP_GL_USE_GTK_GL_AREA
#endif

typedef struct _spGLVisualArchPart {
#if !defined(SP_GL_USE_GTK_GL_AREA)
    GdkGLConfig *glconfig;
#endif
    
    int major_version;
    int minor_version;
#if defined(SP_GL_USE_GTK_GL_AREA)
    gboolean has_alpha;
    gboolean has_depth_buffer;
    gboolean has_stencil_buffer;
#else
    spGLAttribute *core_attributes;
#endif
} spGLVisualArchPart;

typedef struct _spGLContextArchPart {
    GdkGLContext *glcontext;
    spGLContext share;
    char *ext_list;
} spGLContextArchPart;
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGL_GTK_H */
