/*
 *	spGL_Win.h
 */

#ifndef __SPGL_WIN_H
#define __SPGL_WIN_H

#include <windows.h>
#include <sp/spGraphics.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _spGLVisualArchPart {
    PIXELFORMATDESCRIPTOR pfd;

    spGLAttribute *core_attribs;
    spGLAttribute *context_attribs;
} spGLVisualArchPart;

typedef struct _spGLContextArchPart {
    HGLRC hglrc;
    spGraphics graphics;
    char *ext_list;
} spGLContextArchPart;

#if defined(_M_ARM64)
extern spBool spGLLoadGLFunctionsWin(void);
extern void spGLUnloadGLFunctionsWin(void *data);
#endif

extern spBool spGetStringExtentWinGP(HDC hdc, HFONT hfont, WCHAR *wstr, 
				     int *x, int *y, int *width, int *height, int *next_x);
extern spBool spDrawStringToBitmapDataWinGP(HDC hdc, HFONT hfont, DWORD fg_pixel, int topleft_x, int topleft_y,
					    int bitmap_width, int bitmap_height, int stride, BYTE *data, WCHAR *wstr);
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGL_WIN_H */
