#   File:       spComponentEx-ppc.make
#   Target:     spComponentEx-ppc
#   Created:    Monday, September 10, 2007 12:15:51 AM


MAKEFILE        = spComponentEx-ppc.make
# MondoBuild    = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified
MondoBuild    =

SpBaseDir       = ::spBase:
SpComponentDir  = ::spComponent:
SpLibDir  	    = ::lib:

ObjDir          = :
Includes        =  
				  -i : 
				  -i {SpBaseDir} -i {SpComponentDir}

Sym-PPC         = -sym off

PPCCOptions     = {Includes} {Sym-PPC} -d CALL_NOT_IN_CARBON=1 -includes unix -enum int -j0 -w 35


### Source Files ###

SrcFiles        =  
				  spGL.c 
				  spGL_Mac.c 
				  spGLPhongModel.c 
				  spGLShader.c 
				  spGLString.c 
				  spGLString_Mac.c


### Object Files ###

ObjFiles-PPC    =  
				  "{ObjDir}spGL.c.x" 
				  "{ObjDir}spGL_Mac.c.x" 
				  "{ObjDir}spGLPhongModel.c.x" 
				  "{ObjDir}spGLShader.c.x" 
				  "{ObjDir}spGLString.c.x" 
				  "{ObjDir}spGLString_Mac.c.x"


### Libraries ###

LibFiles-PPC    = 


### Default Rules ###

.c.x    .c  {MondoBuild}
	{PPCC} {depDir}{default}.c -o {targDir}{default}.c.x {PPCCOptions}


### Build Rules ###

spComponentEx-ppc      spComponentEx-ppc.o

spComponentEx-ppc.o    {ObjFiles-PPC} {LibFiles-PPC} {MondoBuild}
	PPCLink 
		-o {Targ} 
		{ObjFiles-PPC} 
		{LibFiles-PPC} 
		{Sym-PPC} 
		-mf -d 
		-t 'XCOF' 
		-c 'MPS ' 
		-xm l; 
	Duplicate -y {Targ} {SpLibDir}


### Required Dependencies ###

"{ObjDir}spGL.c.x"    spGL.c
"{ObjDir}spGL_Mac.c.x"    spGL_Mac.c
"{ObjDir}spGLPhongModel.c.x"    spGLPhongModel.c
"{ObjDir}spGLShader.c.x"    spGLShader.c
"{ObjDir}spGLString.c.x"    spGLString.c
"{ObjDir}spGLString_Mac.c.x"    spGLString_Mac.c


### Optional Dependencies ###
### Build this target to generate "include file" dependencies. ###

Dependencies    $OutOfDate
	MakeDepend 
		-append {MAKEFILE} 
		-ignore "{CIncludes}" 
		-objdir "{ObjDir}" 
		-objext .x 
		{Includes} 
		{SrcFiles}


