#include <math.h>
#include <sp/spFile.h>
#include <sp/spComponentLib.h>

#if defined(ANDROID) || defined(IPHONE)
#define USE_OPENGL_ES2 1
#endif

#include <sp/spGLP.h>
#include <sp/spGLShaderP.h>

#if defined(_WIN32) && !(defined(USE_MOTIF) || defined(GTK))
SP_WGL_DECLARE_FUNCTION(glActiveTexture)
SP_WGL_DECLARE_FUNCTION(glClientActiveTexture)

SP_WGL_DECLARE_FUNCTION(glEnableVertexAttribArray)
SP_WGL_DECLARE_FUNCTION(glDisableVertexAttribArray)
SP_WGL_DECLARE_FUNCTION(glVertexAttribPointer)

SP_WGL_DECLARE_FUNCTION(glIsBuffer)
SP_WGL_DECLARE_FUNCTION(glGenBuffers)
SP_WGL_DECLARE_FUNCTION(glDeleteBuffers)
SP_WGL_DECLARE_FUNCTION(glBindBuffer)
SP_WGL_DECLARE_FUNCTION(glBufferData)
SP_WGL_DECLARE_FUNCTION(glBufferSubData)

SP_WGL_DECLARE_FUNCTION(glIsVertexArray)
SP_WGL_DECLARE_FUNCTION(glGenVertexArrays)
SP_WGL_DECLARE_FUNCTION(glDeleteVertexArrays)
SP_WGL_DECLARE_FUNCTION(glBindVertexArray)


SP_WGL_DECLARE_FUNCTION(glGetProgramiv)
SP_WGL_DECLARE_FUNCTION(glGetProgramInfoLog)
SP_WGL_DECLARE_FUNCTION(glGetShaderiv)
SP_WGL_DECLARE_FUNCTION(glGetShaderInfoLog)
SP_WGL_DECLARE_FUNCTION(glAttachShader)
SP_WGL_DECLARE_FUNCTION(glDetachShader)
SP_WGL_DECLARE_FUNCTION(glCreateProgram)
SP_WGL_DECLARE_FUNCTION(glDeleteProgram)
SP_WGL_DECLARE_FUNCTION(glCreateShader)
SP_WGL_DECLARE_FUNCTION(glDeleteShader)
SP_WGL_DECLARE_FUNCTION(glCompileShader)
SP_WGL_DECLARE_FUNCTION(glIsProgram)
SP_WGL_DECLARE_FUNCTION(glIsShader)
SP_WGL_DECLARE_FUNCTION(glLinkProgram)
SP_WGL_DECLARE_FUNCTION(glUseProgram)
SP_WGL_DECLARE_FUNCTION(glShaderSource)
SP_WGL_DECLARE_FUNCTION(glGetShaderSource)
SP_WGL_DECLARE_FUNCTION(glGetAttribLocation)
SP_WGL_DECLARE_FUNCTION(glGetUniformLocation)
SP_WGL_DECLARE_FUNCTION(glUniform1i)
SP_WGL_DECLARE_FUNCTION(glUniformMatrix4fv)
SP_WGL_DECLARE_FUNCTION(glUniform1f)
SP_WGL_DECLARE_FUNCTION(glUniform3fv)
SP_WGL_DECLARE_FUNCTION(glUniform4fv)

spBool spInitShaderGLFunctionsWin(HGLRC *global_hglrc)
{
    HGLRC hglrc;

    hglrc = wglGetCurrentContext();
    
    if (global_hglrc != NULL && hglrc == *global_hglrc) {
	spDebug(80, "spInitShaderGLFunctionsWin", "functions have already been loaded\n");
	return SP_TRUE;
    }

    if (global_hglrc != NULL) {
        spDebug(80, "spInitShaderGLFunctionsWin", "hglrc = %ld, *global_hglrc = %ld\n",
                (long)hglrc, (long)*global_hglrc);
        *global_hglrc = NULL;
    }

    SP_WGL_LOAD_EXT_FUNCTION(glActiveTexture);
    if (spIsWGLFunctionLoaded(glActiveTexture) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glClientActiveTexture);
    if (spIsWGLFunctionLoaded(glClientActiveTexture) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glGetProgramiv);
    if (spIsWGLFunctionLoaded(glGetProgramiv) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glGetProgramInfoLog);
    if (spIsWGLFunctionLoaded(glGetProgramInfoLog) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glGetShaderiv);
    if (spIsWGLFunctionLoaded(glGetShaderiv) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glGetShaderInfoLog);
    if (spIsWGLFunctionLoaded(glGetShaderInfoLog) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glAttachShader);
    if (spIsWGLFunctionLoaded(glAttachShader) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glDetachShader);
    if (spIsWGLFunctionLoaded(glDetachShader) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glCreateProgram);
    if (spIsWGLFunctionLoaded(glCreateProgram) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glDeleteProgram);
    if (spIsWGLFunctionLoaded(glDeleteProgram) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glCreateShader);
    if (spIsWGLFunctionLoaded(glCreateShader) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glDeleteShader);
    if (spIsWGLFunctionLoaded(glDeleteShader) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glCompileShader);
    if (spIsWGLFunctionLoaded(glCompileShader) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glIsProgram);
    if (spIsWGLFunctionLoaded(glIsProgram) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glIsShader);
    if (spIsWGLFunctionLoaded(glIsShader) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glLinkProgram);
    if (spIsWGLFunctionLoaded(glLinkProgram) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glUseProgram);
    if (spIsWGLFunctionLoaded(glUseProgram) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glShaderSource);
    if (spIsWGLFunctionLoaded(glShaderSource) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glGetShaderSource);
    if (spIsWGLFunctionLoaded(glGetShaderSource) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glGetAttribLocation);
    if (spIsWGLFunctionLoaded(glGetAttribLocation) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glGetUniformLocation);
    if (spIsWGLFunctionLoaded(glGetUniformLocation) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glEnableVertexAttribArray);
    if (spIsWGLFunctionLoaded(glEnableVertexAttribArray) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glDisableVertexAttribArray);
    if (spIsWGLFunctionLoaded(glDisableVertexAttribArray) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glUniform1i);
    if (spIsWGLFunctionLoaded(glUniform1i) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glUniformMatrix4fv);
    if (spIsWGLFunctionLoaded(glUniformMatrix4fv) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glUniform1f);
    if (spIsWGLFunctionLoaded(glUniform1f) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glUniform3fv);
    if (spIsWGLFunctionLoaded(glUniform3fv) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glUniform4fv);
    if (spIsWGLFunctionLoaded(glUniform4fv) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glVertexAttribPointer);
    if (spIsWGLFunctionLoaded(glVertexAttribPointer) == SP_FALSE) return SP_FALSE;

    SP_WGL_LOAD_EXT_FUNCTION(glIsBuffer);
    if (spIsWGLFunctionLoaded(glIsBuffer) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glGenBuffers);
    if (spIsWGLFunctionLoaded(glGenBuffers) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glDeleteBuffers);
    if (spIsWGLFunctionLoaded(glDeleteBuffers) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glBindBuffer);
    if (spIsWGLFunctionLoaded(glBindBuffer) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glBufferData);
    if (spIsWGLFunctionLoaded(glBufferData) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glBufferSubData);
    if (spIsWGLFunctionLoaded(glBufferSubData) == SP_FALSE) return SP_FALSE;
    
    SP_WGL_LOAD_EXT_FUNCTION(glIsVertexArray);
    SP_WGL_LOAD_EXT_FUNCTION(glGenVertexArrays);
    SP_WGL_LOAD_EXT_FUNCTION(glDeleteVertexArrays);
    SP_WGL_LOAD_EXT_FUNCTION(glBindVertexArray);
    
    if (global_hglrc != NULL) {
        *global_hglrc = hglrc;
    }
    
    return SP_TRUE;
}
#elif defined(ANDROID)

SP_EGL_DECLARE_FUNCTION(glIsVertexArrayOES)
SP_EGL_DECLARE_FUNCTION(glGenVertexArraysOES)
SP_EGL_DECLARE_FUNCTION(glDeleteVertexArraysOES)
SP_EGL_DECLARE_FUNCTION(glBindVertexArrayOES)

spBool spInitShaderGLFunctionsAndroid(void)
{
    SP_EGL_LOAD_EXT_FUNCTION(glIsVertexArrayOES);
    SP_EGL_LOAD_EXT_FUNCTION(glGenVertexArraysOES);
    SP_EGL_LOAD_EXT_FUNCTION(glDeleteVertexArraysOES);
    SP_EGL_LOAD_EXT_FUNCTION(glBindVertexArrayOES);
    
    return SP_TRUE;
}
#endif

spBool spGLShaderGetVersion(unsigned long options, unsigned long *min_version, unsigned long *max_version, spBool *es_flag)
{
    char *version_string;

    if ((version_string = (char *)glGetString(GL_SHADING_LANGUAGE_VERSION)) != NULL) {
        double fversion;
        unsigned long version;
        char buf[SP_MAX_LINE];
        spDebug(10, "spGLShaderGetVersion", "GL_SHADING_LANGUAGE_VERSION = %s\n", version_string);

#if defined(IPHONE) || defined(ANDROID)
        if (spStrNCaseEq(version_string, "OpenGL ES GLSL ES ", 18)) {
            version_string = version_string + 18;
        }
#endif
        
        if (spSGetNColumn(buf, sizeof(buf), 0, version_string) >= 1) {
            fversion = -1.0;
            sscanf(buf, "%lf", &fversion);
            spDebug(80, "spGLShaderGetVersion", "buf = %s, fversion = %f\n", buf, fversion);
            
            if (fversion >= 1.0) {
                fversion *= 100.0;
                version = (unsigned long)spRound(fversion);
                spDebug(80, "spGLShaderGetVersion", "fversion = %f, version = %ld\n", fversion, version);
#if defined(IPHONE) || defined(ANDROID)
                if (options & SP_GL_SHADER_GET_VERSION_OPTION_WITH_MODERN_API) {
                    if (version < 300) {
                        return SP_FALSE;
                    }
                }
#elif defined(COCOA) && !defined(IPHONE)
                if (options & SP_GL_SHADER_GET_VERSION_OPTION_WITH_MODERN_API) {
                    if (version < 150) {
                        return SP_FALSE;
                    }
                }
#endif

                if (es_flag != NULL) {
#if defined(IPHONE) || defined(ANDROID)
                    *es_flag = SP_TRUE;
#else
                    *es_flag = SP_FALSE;
#endif
                }
                
                if (max_version != NULL) {
                    *max_version = version;
#if defined(COCOA) && !defined(IPHONE)
                    if (options & SP_GL_SHADER_GET_VERSION_OPTION_WITH_LEGACY_API) {
                        *max_version = MIN(*max_version, 120);
                    }
#endif
                }
                if (min_version != NULL) {
#if defined(IPHONE) || defined(ANDROID)
                    *min_version = 100;
#else
                    *min_version = 110;
#endif
#if defined(COCOA) && !defined(IPHONE)
                    if (options & SP_GL_SHADER_GET_VERSION_OPTION_WITH_MODERN_API) {
                        *min_version = MAX(*min_version, 150);
                    }
#endif
                }

                return SP_TRUE;
            }
        } else {
            spDebug(10, "spGLShaderGetVersion", "spSGetNColumn failed\n");
        }
    }

    return SP_FALSE;
}

/*
 * Including the following macros (LEGACY <--> MODERN): 
 * vertex shader:
 *   attribute <--> in
 *   varying <--> out
 *   "" <-- flat
 * fragment shader:
 *   varying <--> in
 *   "" <-- flat
 *   gl_FragColor <--> FragColor (~SP_GL_SHADER_GET_PREFIX_OPTION_USE_FRAG_DATA)
 *   gl_FragData <--> FragData (SP_GL_SHADER_GET_PREFIX_OPTION_USE_FRAG_DATA)
 */
GLchar *xspGLShaderGetPrefix(GLenum shader_type, unsigned long options, unsigned long version, unsigned long source_version, spBool es_flag)
{
    static const GLchar shader_version_line_format[] = "#version %ld\n";
    static const GLchar float_high_precision_line[] =
        "precision highp float;\n"
        ;
    static const GLchar float_medium_precision_line[] =
        "precision mediump float;\n"
        ;
    static const GLchar macros_for_oldversion[] =
        "#define gl_MaxVaryingComponents gl_MaxVaryingFloats\n"
        ;
    static const GLchar macros_for_version130[] =
        "#define gl_MaxVaryingFloats gl_MaxVaryingComponents\n"
        ;
    static const GLchar vertex_shader_macros_for_oldversion[] =
        "#define in attribute\n"
        "#define out varying\n"
        ;
    static const GLchar vertex_shader_macros_for_version130[] =
        "#define attribute in\n"
        "#define varying out\n"
        ;
    static const GLchar fragment_shader_macros_for_oldversion[] =
        "#define in varying\n"
        ;
    static const GLchar fragment_shader_macros_for_version130[] =
        "#define varying in\n"
        ;
    static const GLchar fragColor_replace_macros_for_oldversion[] =
        "#define FragColor gl_FragColor\n"
        ;
    static const GLchar fragColor_replace_macros_for_version130[] =
        "#define gl_FragColor FragColor\nout vec4 FragColor;\n"
        ;
    static const GLchar fragData_replace_macros_for_oldversion[] =
        "#define FragData gl_FragData\n"
        ;
    static const GLchar fragData_replace_macros_for_version130[] =
        "#define gl_FragData FragData\nout vec4 FragData[gl_MaxDrawBuffers];\n"
        ;
    static const GLchar flat_invalidate_macros[] =
        "#define flat  \n"
        ;
    GLchar source[512];

    if (version >= 110 || (es_flag && version == 100)) {
        sprintf(source, shader_version_line_format, version);
    } else {
        source[0] = '\n'; source[1] = NUL;
    }

    if (!(options & SP_GL_SHADER_GET_PREFIX_OPTION_NO_DEFAULT_PRECISION)) {
        if (es_flag) {
            if (shader_type == GL_FRAGMENT_SHADER) {
                spStrCat(source, sizeof(source), (char *)float_medium_precision_line);
            } else {
                spStrCat(source, sizeof(source), (char *)float_high_precision_line);
            }
        } else if (version >= 130) {
            spStrCat(source, sizeof(source), (char *)float_high_precision_line);
        }
    }
    
    if (version < 150) {
        spStrCat(source, sizeof(source), (char *)flat_invalidate_macros);
    }
    if (version >= 130) {
        if (source_version < 130) {
            spStrCat(source, sizeof(source), (char *)macros_for_version130);
        
            if (shader_type == GL_FRAGMENT_SHADER) {
                spStrCat(source, sizeof(source), (char *)fragment_shader_macros_for_version130);
            } else if (shader_type == GL_VERTEX_SHADER) {
                spStrCat(source, sizeof(source), (char *)vertex_shader_macros_for_version130);
            }
        }
        
        if (shader_type == GL_FRAGMENT_SHADER) {
            if (source_version < 130 || (options & SP_GL_SHADER_GET_PREFIX_OPTION_USE_LEGACY_FRAGMENT_OUTPUT)) {
                if (options & SP_GL_SHADER_GET_PREFIX_OPTION_USE_FRAG_DATA) {
                    spStrCat(source, sizeof(source), (char *)fragData_replace_macros_for_version130);
                } else {
                    spStrCat(source, sizeof(source), (char *)fragColor_replace_macros_for_version130);
                }
            }
        }
    } else {
        if (source_version >= 130) {
            spStrCat(source, sizeof(source), (char *)macros_for_oldversion);
        
            if (shader_type == GL_FRAGMENT_SHADER) {
                spStrCat(source, sizeof(source), (char *)fragment_shader_macros_for_oldversion);
                
                if (!(options & SP_GL_SHADER_GET_PREFIX_OPTION_USE_LEGACY_FRAGMENT_OUTPUT)) {
                    if (options & SP_GL_SHADER_GET_PREFIX_OPTION_USE_FRAG_DATA) {
                        spStrCat(source, sizeof(source), (char *)fragData_replace_macros_for_oldversion);
                    } else {
                        spStrCat(source, sizeof(source), (char *)fragColor_replace_macros_for_oldversion);
                    }
                }
            } else if (shader_type == GL_VERTEX_SHADER) {
                spStrCat(source, sizeof(source), (char *)vertex_shader_macros_for_oldversion);
            }
        }
    }

    return strclone(source);
}

GLchar *_xspGLShaderGetShaderInfoLog(void (SPGLAPI *getShaderivProc)(GLuint, GLenum, GLint *),
                                     void (SPGLAPI *getShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                     GLuint shader)
{
#if defined(SP_GL_SHADER_SUPPORTED)
    GLsizei buf_size;
    GLchar *info_log = NULL;
	
    (*getShaderivProc)(shader, GL_INFO_LOG_LENGTH , &buf_size);

    if (buf_size > 1) {
        GLsizei length;

        if ((info_log = xalloc(buf_size, GLchar)) != NULL) {
            (*getShaderInfoLogProc)(shader, buf_size, &length, info_log);
        }
    }

    return info_log;
#else
    return 0;
#endif
}

GLchar *_xspGLShaderGetProgramInfoLog(void (SPGLAPI *getProgramivProc)(GLuint, GLenum, GLint *),
                                      void (SPGLAPI *getProgramInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                      GLuint program)
{
#if defined(SP_GL_SHADER_SUPPORTED)
    GLsizei buf_size;
    GLchar *info_log = NULL;
	
    (*getProgramivProc)(program, GL_INFO_LOG_LENGTH , &buf_size);

    if (buf_size > 1) {
        GLsizei length;

        if ((info_log = xalloc(buf_size, GLchar)) != NULL) {
            (*getProgramInfoLogProc)(program, buf_size, &length, info_log);
        }
    }

    return info_log;
#else
    return 0;
#endif
}

GLint _spGLShaderCheckCompileError(void (SPGLAPI *getShaderivProc)(GLuint, GLenum, GLint *),
                                   void (SPGLAPI *getShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                   GLuint shader)
{
#if defined(SP_GL_SHADER_SUPPORTED)
    GLint status;

    (*getShaderivProc)(shader, GL_COMPILE_STATUS, &status);

    if (status == GL_FALSE) {
        GLchar *info_log;
        
        if ((info_log = _xspGLShaderGetShaderInfoLog(getShaderivProc, getShaderInfoLogProc, shader)) != NULL) {
            spWarning("%s\n", info_log);
            xfree(info_log);
	}
    }

    return status;
#else
    return 0;
#endif
}

GLint _spGLShaderCheckLinkError(void (SPGLAPI *getProgramivProc)(GLuint, GLenum, GLint *),
                                void (SPGLAPI *getProgramInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                GLuint program)
{
#if defined(SP_GL_SHADER_SUPPORTED)
    GLint status;

    (*getProgramivProc)(program, GL_LINK_STATUS, &status);

    if (status == GL_FALSE) {
        GLchar *info_log;

        if ((info_log = _xspGLShaderGetProgramInfoLog(getProgramivProc, getProgramInfoLogProc, program)) != NULL) {
            spWarning("%s\n", info_log);
            xfree(info_log);
	}
    }

    return status;
#else
    return 0;
#endif
}

GLuint _spGLShaderCompile(GLuint (SPGLAPI *createShaderProc)(GLenum),
                          void (SPGLAPI *shaderSourceProc)(GLuint, GLsizei, const GLchar * const*, const GLint *),
                          void (SPGLAPI *compileShaderProc)(GLuint),
                          void (SPGLAPI *getShaderivProc)(GLuint, GLenum, GLint *),
                          void (SPGLAPI *getShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                          GLenum shader_type, const GLchar *source)
{
#if defined(SP_GL_SHADER_SUPPORTED)
    GLuint shader;

    if ((shader = (*createShaderProc)(shader_type)) != 0) {
	(*shaderSourceProc)(shader, 1, &source, NULL);
	(*compileShaderProc)(shader);

	if (_spGLShaderCheckCompileError(getShaderivProc, getShaderInfoLogProc, shader) == GL_FALSE) {
	    glDeleteShader(shader);
	    shader = 0;
	}
    }
    
    return shader;
#else
    return 0;
#endif
}

GLuint _spGLShaderCompileAndAttach(GLuint (SPGLAPI *createShaderProc)(GLenum),
                                   void (SPGLAPI *shaderSourceProc)(GLuint, GLsizei, const GLchar * const*, const GLint *),
                                   void (SPGLAPI *compileShaderProc)(GLuint),
                                   void (SPGLAPI *attachShaderProc)(GLuint, GLuint),
                                   void (SPGLAPI *getShaderivProc)(GLuint, GLenum, GLint *),
                                   void (SPGLAPI *getShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                   GLuint program, GLenum shader_type, const GLchar *source)
{
#if defined(SP_GL_SHADER_SUPPORTED)
    GLuint shader;

    shader = _spGLShaderCompile(createShaderProc, shaderSourceProc, compileShaderProc,
                                getShaderivProc, getShaderInfoLogProc, shader_type, source);

    if (shader != 0) {
        (*attachShaderProc)(program, shader);
    }
    
    return shader;
#else
    return 0;
#endif
}
