#include <sp/spComponentP.h>
#include <sp/spCanvasP.h>
#include <sp/spGraphicsP.h>
#include <sp/spDrawP.h>

#include <sp/spGLStringP.h>

extern spTopLevel sp_toplevel;

#if defined(SP_GL_STRING_USE_PANGO)
spDIBitmap spCreateDIBitmapStringPango(spGLString glstring, char *string)
{
    int ascent, descent;
    char *tstring;
    PangoLayout *layout;
    PangoRectangle rect, lrect;
    int bitmap_width, bitmap_height;
    spDIBitmap dibitmap = NULL;
    spDIBitmapInfo dibinfo;

    spDebug(100, "spCreateDIBitmapStringPango", "in\n");

    if ((tstring = (char *)g_locale_to_utf8(string, -1, NULL, NULL, NULL)) == NULL) {
        spDebug(10, "spCreateDIBitmapStringPango", "g_locale_to_utf8 failed\n");
        return NULL;
    }
    spDebug(80, "spCreateDIBitmapStringPango", "tstring = %s\n", tstring);

    if ((layout = pango_layout_new(SpTopLevelArch(sp_toplevel).context)) == NULL) {
        spDebug(10, "spCreateDIBitmapStringPango", "pango_layout_new failed\n");
    } else {
        SpGLStringArch(glstring).font_desc = pango_font_description_from_string(SP_GTK_DEFAULT_FONT_NAME);
        if (!strnone(SpGLStringPart(glstring).font_name)) {
            spDebug(80, "spCreateDIBitmapStringPango", "SpGLStringPart(glstring).font_name = %s\n",
                    SpGLStringPart(glstring).font_name);
            spFontNameToFontDescriptionGtk(SpGLStringPart(glstring).font_name, SpGLStringArch(glstring).font_desc);
        }
    
        pango_layout_set_font_description(layout, SpGLStringArch(glstring).font_desc);
        pango_layout_set_text(layout, tstring, -1);
        pango_layout_get_pixel_extents(layout, &rect, &lrect);

        spGetFontDescAscentGtk(layout, SpGLStringArch(glstring).font_desc, &ascent, &descent);

        SpGLStringPart(glstring).x = lrect.x;
        SpGLStringPart(glstring).y = -ascent;
        SpGLStringPart(glstring).width = lrect.width;
        SpGLStringPart(glstring).height = lrect.height;
        SpGLStringPart(glstring).next_x = lrect.x + lrect.width;
        spDebug(80, "spCreateDIBitmapStringPango", "x = %d, y = %d, width = %d, height = %d, next_x = %d\n",
                SpGLStringPart(glstring).x, SpGLStringPart(glstring).y, SpGLStringPart(glstring).width,
                SpGLStringPart(glstring).height, SpGLStringPart(glstring).next_x);
    
        SpGLStringArch(glstring).inside_margin_width = SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_WIDTH;
        SpGLStringArch(glstring).inside_margin_height = SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_HEIGHT;

        bitmap_width = -SpGLStringPart(glstring).x + SpGLStringPart(glstring).width + 2 * SpGLStringArch(glstring).inside_margin_width;
        bitmap_height = SpGLStringPart(glstring).height + 2 * SpGLStringArch(glstring).inside_margin_height;

        dibinfo.pixel_format = SP_DI_PIXEL_FORMAT_BGRA;
        dibinfo.width = bitmap_width;
        dibinfo.height = bitmap_height;
        dibinfo.upside_down = SP_FALSE;
        dibinfo.bit_size = 8;
    
        if ((dibitmap = spCreateDIBitmap(&dibinfo)) != NULL) {
	    if (spLockDIBitmap(dibitmap) == SP_TRUE) {
                cairo_surface_t *surface;
                
#if GTK_CHECK_VERSION(3,0,0) && defined(SP_DIBITMAP_USE_CAIRO_IMAGE)
                surface = (cairo_surface_t *)dibitmap->dibitmap;
#else
                surface = cairo_image_surface_create_for_data(gdk_pixbuf_get_pixels((GdkPixbuf *)dibitmap->dibitmap),
                                                              CAIRO_FORMAT_ARGB32, bitmap_width, bitmap_height,
                                                              gdk_pixbuf_get_rowstride((GdkPixbuf *)dibitmap->dibitmap));
#endif
                spDebug(100, "spCreateDIBitmapStringPango", "surface = %lx\n", (long)surface);
                
                if (surface != NULL) {
                    cairo_t *cr;
                    
                    if ((cr = cairo_create(surface)) != NULL) {
#if GTK_CHECK_VERSION(3,4,0)
                        GdkRGBA rgba;
                        spPixelToGdkRGBA(SpGLStringPart(glstring).fg_pixel, &rgba);
                        gdk_cairo_set_source_rgba(cr, &rgba);
                        spDebug(100, "spCreateDIBitmapStringPango", "r = %f, g = %f, b = %f, a = %f\n",
                                rgba.red, rgba.green, rgba.blue, rgba.alpha);
#else
                        GdkColor color;
                        spPixelToGdkColor(SpGLStringPart(glstring).fg_pixel, &color);
                        gdk_cairo_set_source_color(cr, &color);
#endif

                        cairo_move_to(cr, -SpGLStringPart(glstring).x,
                                      -SpGLStringPart(glstring).y - lrect.height + descent);
                        pango_cairo_show_layout(cr, layout);

                        cairo_destroy(cr);
                    } else {
                        spDebug(10, "spCreateDIBitmapStringArch", "cairo_create failed\n");
                    }
                    
#if !defined(SP_DIBITMAP_USE_CAIRO_IMAGE)
                    cairo_surface_destroy(surface);
#endif
                } else {
                    spDebug(10, "spCreateDIBitmapStringArch", "cairo_image_surface_create_for_data failed\n");
                }
                
		spUnlockDIBitmap(dibitmap);
            }
	} else {
	    spDebug(10, "spCreateDIBitmapStringArch", "spCreateDIBitmap failed\n");
        }
    
        g_object_unref(layout);
    }

    g_free(tstring);
    
    spDebug(80, "spCreateDIBitmapStringArch", "done: dibitmap = %lx\n", (long)dibitmap);
    
    return dibitmap;
}

spBool spGLStringByTextureDestroyPango(spGLString glstring)
{
    if (SpGLStringArch(glstring).font_desc != NULL) {
	pango_font_description_free(SpGLStringArch(glstring).font_desc);
	SpGLStringArch(glstring).font_desc = NULL;
    }
    
    return SP_TRUE;
}
#endif

void spGLStringPartInitArch(spGLString glstring)
{
    return;
}

void spGLStringPartFreeArch(spGLString glstring)
{
    return;
}

#if defined(SP_GL_STRING_BY_TEXTURE)
spDIBitmap spCreateDIBitmapStringArch(spGLString glstring, char *string)
{
#if defined(SP_GL_STRING_USE_PANGO)
    return spCreateDIBitmapStringPango(glstring, string);
#else
    return spCreateDIBitmapStringX11(glstring, string);
#endif
}
#endif

spBool spGLStringCreateArch(spGLString glstring, char *string)
{
#if defined(SP_GL_STRING_BY_TEXTURE)
    if (SpGLStringPart(glstring).use_texture == SP_TRUE || SpGLStringPart(glstring).use_shader == SP_TRUE) {
	return spGLStringByTextureCreate(glstring, string);
    }
#endif
    
#if defined(SP_GL_STRING_USE_PANGO)
    return SP_FALSE;
#else
    return spGLStringCreateX11(glstring, string);
#endif
}

spBool spGLStringDestroyArch(spGLString glstring)
{
#if defined(SP_GL_STRING_BY_TEXTURE)
#if defined(SP_GL_STRING_USE_PANGO)
    spGLStringByTextureDestroyPango(glstring);
#else
    spGLStringByTextureDestroyX11(glstring);
#endif
#endif
    
#if defined(SP_GL_STRING_USE_PANGO)
    return SP_FALSE;
#else
    return spGLStringDestroyX11(glstring);
#endif
}

spBool spGetGLStringExtentArch(spComponent gldrawable, spGLString glstring)
{
#if defined(SP_GL_STRING_BY_TEXTURE)
    if (SpGLStringPart(glstring).width <= 0 || SpGLStringPart(glstring).height <= 0) {
	return SP_FALSE;
    } else {
	return SP_TRUE;
    }
#else
    return SP_TRUE;
#endif
}

spBool spDrawGLStringArch(spComponent gldrawable, spGLString glstring)
{
#if defined(SP_GL_STRING_BY_TEXTURE)
    return spDrawGLStringByTexture(gldrawable, glstring, 1.0f);
#else
    return SP_FALSE;
#endif
}
