#include <sp/spComponent.h>
#include <sp/spGraphicsP.h>
#include <sp/spCanvasP.h>
#include <sp/spDrawP.h>

#include <sp/spGLP.h>
#include <sp/spGLStringP.h>

void spGLStringPartInitArch(spGLString glstring)
{
    return;
}

void spGLStringPartFreeArch(spGLString glstring)
{
    return;
}

spBool spGLStringCreateArch(spGLString glstring, char *string)
{
    spGLContext context;
    int i;
    int id;
    unsigned char c, pc;
    int mbc;
    spBool flag;
    int cu, cl;
    spComponent gldrawable;

    gldrawable = SpGLStringPart(glstring).gldrawable;

    if ((context = SpGLCanvasPart(gldrawable).current_context) == NULL
	|| SpGLContextArch(context).graphics == NULL) {
	return SP_FALSE;
    }
    
    spSetGraphicsParams(SpGLContextArch(context).graphics,
			SppFontName, SpGLStringPart(glstring).font_name,
			NULL);

    pc = string[0];
    id = SpGLStringPart(glstring).list_base;
    flag = SP_TRUE;
	
    for (i = 1; pc != '\0'; i++) {
	c = string[i];
	spDebug(100, "spGLStringCreateArch", "i = %d, id = %d, pc = %x (%d), c = %x (%d)\n", i, id, pc, pc, c, c); 

	if (c != '\0' && spIsMBTailCandidate(pc, c) == SP_TRUE) {
	    cu = pc & 0xff;
	    cl = c & 0xff;
	    mbc = (cu * 256) + cl;
	    spDebug(100, "spGLStringCreateArch", "cu = %d, cl = %d, mbc = %d\n", cu, cl, mbc);

	    if (spGLUseFontMac(SpGLContextArch(context).graphics, mbc, 1, id) != SP_TRUE) {
		spDebug(100, "spGLStringCreateArch", "Cannot find suitable font for char %d\n", pc);
		flag = SP_FALSE;
		break;
	    }
	    
	    i++;
	    c = string[i];
	} else {
	    spDebug(100, "spGLStringCreateArch", "normal char: pc = %c, id = %d\n", pc, id);
	    
	    if (spGLUseFontMac(SpGLContextArch(context).graphics, pc, 1, id) != SP_TRUE) {
		spDebug(100, "spGLStringCreateArch", "Cannot find suitable font for char %d\n", pc);
		flag = SP_FALSE;
		break;
	    }
	}
	
	pc = c;
	    
	id++;
    }
    
    if (flag == SP_TRUE) {
	SpGLStringPart(glstring).count = id - SpGLStringPart(glstring).list_base;
	
	spGetStringExtentArch(gldrawable, SpGLContextArch(context).graphics, string,
			      &SpGLStringPart(glstring).x, &SpGLStringPart(glstring).y,
			      &SpGLStringPart(glstring).width, &SpGLStringPart(glstring).height,
			      &SpGLStringPart(glstring).next_x);
    }
    spDebug(100, "spGLStringCreateArch", "spGetStringExtentArch: width = %d, height = %d\n", SpGLStringPart(glstring).width, SpGLStringPart(glstring).height);
    
    return flag;
}

spBool spGLStringDestroyArch(spGLString glstring)
{
    return SP_TRUE;
}

spBool spGetGLStringExtentArch(spComponent gldrawable, spGLString glstring)
{
    if (SpGLStringPart(glstring).width <= 0 || SpGLStringPart(glstring).height <= 0) {
	return SP_FALSE;
    } else {
	return SP_TRUE;
    }
}

spBool spDrawGLStringArch(spComponent gldrawable, spGLString glstring)
{
    return SP_FALSE;
}
