#include <sp/spComponent.h>
#include <sp/spCanvasP.h>
#include <sp/spGraphicsP.h>
#include <sp/spDrawP.h>

#include <sp/spGLP.h>
#include <sp/spGLStringP.h>

void spGLStringPartInitArch(spGLString glstring)
{
    return;
}

void spGLStringPartFreeArch(spGLString glstring)
{
    return;
}

spDIBitmap spCreateDIBitmapStringArch(spGLString glstring, char *string)
{
    spGLContext context;
    spComponent gldrawable;
    spDIBitmap dibitmap = NULL;
    spDIBitmapInfo dibinfo;
    int bitmap_width, bitmap_height;
    HDC hdc;
    WCHAR *wstr;
    int nchar;
    
    spDebug(80, "spCreateDIBitmapStringArch", "in\n");
    
    gldrawable = SpGLStringPart(glstring).gldrawable;
    
    if ((context = SpGLCanvasPart(gldrawable).current_context) == NULL
	|| SpGLContextArch(context).graphics == NULL) {
        spDebug(10, "spCreateDIBitmapStringArch", "no context\n"); 
	return NULL;
    }
    
    hdc = GetDC(SpPrimitiveArch(gldrawable).hwnd);
    
    if (hdc == NULL) {
        spDebug(10, "spCreateDIBitmapStringArch", "GetDC failed\n"); 
	return NULL;
    }
    
    nchar = MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, (LPSTR)string, -1, NULL, 0);
    wstr = xalloc(nchar + 1, WCHAR);

    if (MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, (LPSTR)string, -1, wstr, nchar) != 0) {
	SpGLStringArch(glstring).inside_margin_width = SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_WIDTH;
	SpGLStringArch(glstring).inside_margin_height = SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_HEIGHT;

	spGetStringExtentWinGP(hdc, SpGraphicsArch(SpGLContextArch(context).graphics).font, wstr,
			       &SpGLStringPart(glstring).x, &SpGLStringPart(glstring).y,
			       &SpGLStringPart(glstring).width, &SpGLStringPart(glstring).height, &SpGLStringPart(glstring).next_x);

	bitmap_width = SpGLStringPart(glstring).width + 2 * SpGLStringArch(glstring).inside_margin_width;
	bitmap_height = SpGLStringPart(glstring).height + 2 * SpGLStringArch(glstring).inside_margin_height;
	spDebug(50, "spCreateDIBitmapStringArch", "bitmap size = (%d, %d)\n", bitmap_width, bitmap_height);
    
	dibinfo.pixel_format = SP_DI_PIXEL_FORMAT_BGRA;
	dibinfo.width = bitmap_width;
	dibinfo.height = bitmap_height;
	dibinfo.upside_down = SP_FALSE;
	dibinfo.bit_size = 8;
    
	if ((dibitmap = spCreateDIBitmap(&dibinfo)) != NULL) {
	    if (spLockDIBitmap(dibitmap) == SP_TRUE) {
		spDrawStringToBitmapDataWinGP(hdc, SpGraphicsArch(SpGLContextArch(context).graphics).font, SpGLStringPart(glstring).fg_pixel,
					      SpGLStringArch(glstring).inside_margin_width, SpGLStringArch(glstring).inside_margin_height,
					      bitmap_width, bitmap_height, dibitmap->info.line_stride, dibitmap->info.data, wstr);
		spUnlockDIBitmap(dibitmap);
	    }
	} else {
	    spDebug(10, "spCreateDIBitmapStringArch", "spCreateDIBitmap failed\n");
	}
    }
    
    xfree(wstr);
    
    return dibitmap;
}

spBool spGLStringCreateArch(spGLString glstring, char *string)
{
    spGLContext context;
    HDC hdc;
    HFONT prev_font;
    BOOL success;
    int i;
    char c, pc;
    DWORD id;
    char buf[3];
    WCHAR wcbuf[4];
    spComponent gldrawable;

    gldrawable = SpGLStringPart(glstring).gldrawable;
    
    if ((context = SpGLCanvasPart(gldrawable).current_context) == NULL
	|| SpGLContextArch(context).graphics == NULL) {
	return SP_FALSE;
    }
    
    spSetGraphicsParams(SpGLContextArch(context).graphics,
			SppFontName, SpGLStringPart(glstring).font_name,
			NULL);

    if (SpGLStringPart(glstring).use_texture == SP_TRUE || SpGLStringPart(glstring).use_shader == SP_TRUE) {
	if (spInitWinGP() == SP_FALSE) {
	    return SP_FALSE;
	}
	return spGLStringByTextureCreate(glstring, string);
    }
    
    hdc = GetDC(SpPrimitiveArch(gldrawable).hwnd);
    
    if (hdc == NULL) {
        spDebug(10, "spGLStringCreateArch", "Error:GetDC\n"); 
	return SP_FALSE;
    }
    
    success = TRUE;
	
    prev_font = SelectObject(hdc, SpGraphicsArch(SpGLContextArch(context).graphics).font);

    pc = string[0];
    id = SpGLStringPart(glstring).list_base;
	
    for (i = 1; pc != '\0'; i++) {
	spDebug(100, "spGLStringCreateArch", "i = %d\n", i); 
	c = string[i];
	    
	if (c != '\0' && spIsMBTailCandidate(pc, c) == SP_TRUE) {
	    buf[0] = pc; buf[1] = c; buf[2] = '\0';
		
	    if (MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, (LPSTR)buf, -1, wcbuf, 4) == 0) {
		success = FALSE;
		break;
	    }
		
	    if (!(wglUseFontBitmapsW(hdc, wcbuf[0], 1, id))) {
		success = FALSE;
		break;
	    }
	    i++;
	    c = string[i];
	} else {
	    if (!(wglUseFontBitmaps(hdc, pc, 1, id))) {
		success = FALSE;
		break;
	    }
	}
	pc = c;
	    
	id++;
    }

    SelectObject(hdc, prev_font);
    
    if (success) {
	SpGLStringPart(glstring).count = id - SpGLStringPart(glstring).list_base;
	
	spGetStringExtentWin(hdc, SpGLContextArch(context).graphics, string,
			     &SpGLStringPart(glstring).x, &SpGLStringPart(glstring).y,
			     &SpGLStringPart(glstring).width, &SpGLStringPart(glstring).height,
			     &SpGLStringPart(glstring).next_x);
    }

    spDebug(100, "spGLStringCreateArch", "done: %d\n", success);
    
    if (success) {
	return SP_TRUE;
    } else {
	spDebug(50, "spGLStringCreateArch", "wglUseFontBitmaps failed: code = %ld\n", GetLastError()); 
	return SP_FALSE;
    }
}

spBool spGLStringDestroyArch(spGLString glstring)
{
    return SP_TRUE;
}

spBool spGetGLStringExtentArch(spComponent gldrawable, spGLString glstring)
{
    if (SpGLStringPart(glstring).width <= 0 || SpGLStringPart(glstring).height <= 0) {
	return SP_FALSE;
    } else {
	return SP_TRUE;
    }
}

spBool spDrawGLStringArch(spComponent gldrawable, spGLString glstring)
{
    return spDrawGLStringByTexture(gldrawable, glstring, 1.0f);
}
