#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Frame.h>

#include <GL/GLwDrawA.h>

#include <sp/spComponent.h>
#include <sp/spCanvasP.h>
#include <sp/spGLStringP.h>

void spGLStringPartInitArch(spGLString glstring)
{
    return;
}

void spGLStringPartFreeArch(spGLString glstring)
{
    return;
}

#if defined(SP_GL_STRING_BY_TEXTURE)
spDIBitmap spCreateDIBitmapStringArch(spGLString glstring, char *string)
{
    return spCreateDIBitmapStringX11(glstring, string);
}
#endif

spBool spGLStringCreateArch(spGLString glstring, char *string)
{
#if defined(SP_GL_STRING_BY_TEXTURE)
    if (SpGLStringPart(glstring).use_texture == SP_TRUE || SpGLStringPart(glstring).use_shader == SP_TRUE) {
	return spGLStringByTextureCreate(glstring, string);
    }
#endif
    
    return spGLStringCreateX11(glstring, string);
}

spBool spGLStringDestroyArch(spGLString glstring)
{
#if defined(SP_GL_STRING_BY_TEXTURE)
    spGLStringByTextureDestroyX11(glstring);
#endif
    
    return spGLStringDestroyX11(glstring);
}

spBool spGetGLStringExtentArch(spComponent gldrawable, spGLString glstring)
{
#if defined(SP_GL_STRING_BY_TEXTURE)
    if (SpGLStringPart(glstring).width <= 0 || SpGLStringPart(glstring).height <= 0) {
	return SP_FALSE;
    } else {
	return SP_TRUE;
    }
#else
    return SP_TRUE;
#endif
}

spBool spDrawGLStringArch(spComponent gldrawable, spGLString glstring)
{
#if defined(SP_GL_STRING_BY_TEXTURE)
    return spDrawGLStringByTexture(gldrawable, glstring, 1.0f);
#else
    return SP_FALSE;
#endif
}
