#include <sp/spComponent.h>
#include <sp/spGraphicsP.h>
#include <sp/spCanvasP.h>
#include <sp/spDrawP.h>

#include <sp/spGLP.h>

#if defined(MACOSX)
#include <mach-o/dyld.h>
#include <dlfcn.h>
#endif

spBool spGLCanvasCreateArch(spComponent component)
{
    spCanvasCreateArch(component);
    return SP_TRUE;
}

spBool spGLCanvasSetParamsArch(spComponent component)
{
    return SP_TRUE;
}
    
spBool spGLCanvasDestroyArch(spComponent component)
{
    spCanvasDestroyArch(component);
    spPrimitiveDestroyArch(component);
    return SP_TRUE;
}

static void setGLCanvasClip(spComponent component, spGLContext context)
{
#if TARGET_API_MAC_CARBON
    {
	RgnHandle canvas_rgn;
	RgnHandle growbox_rgn;
	RgnHandle clip_rgn;
	Rect rect, window_rect;
	    
	canvas_rgn = NewRgn();
	growbox_rgn = NewRgn();
	clip_rgn = NewRgn();
	
	/* region of this canvas */
	rect = SpPrimitiveArch(component).rect;
	SetRectRgn(canvas_rgn, rect.left, rect.top, rect.right, rect.bottom);

	/* region of grow box */
	spGetPortRectMac(SpPrimitiveArch(SpGetWindow(component)).window, &window_rect);
	SetRectRgn(growbox_rgn,
		   window_rect.right - (SP_SIZE_BOX_SIZE - 1),
		   window_rect.bottom - (SP_SIZE_BOX_SIZE - 1),
		   window_rect.right, window_rect.bottom);

	/* clip_rgn = canvas_rgn - growbox_rgn */
	DiffRgn(canvas_rgn, growbox_rgn, clip_rgn);
	    
	spDebug(50, "setGLCanvasClip", "call aglSetInteger with AGL_CLIP_REGION\n");
	aglSetInteger(SpGLContextArch(context).context, AGL_CLIP_REGION, (const GLint *)clip_rgn);
	    
	DisposeRgn(clip_rgn);
	DisposeRgn(growbox_rgn);
	DisposeRgn(canvas_rgn);
	    
	aglEnable (SpGLContextArch(context).context, AGL_CLIP_REGION);
    }
#endif
    return;
}

spBool spGLCanvasRedrawArch(spComponent component)
{
    spGLContext context;
    spBool flag;

    if (SpPrimitiveArch(SpGetWindow(component)).map_flag == SP_FALSE) {
	return SP_FALSE;
    }

    if ((context = SpGLCanvasPart(component).current_context) == NULL) {
	flag = SP_TRUE;
    } else {
	flag = SP_TRUE;
	if (SpComponentPart(component).client_width != SpGLContextArch(context).prev_canvas_width
	    || SpComponentPart(component).client_height != SpGLContextArch(context).prev_canvas_height) {
	    spDebug(50, "spGLCanvasRedrawArch", "call aglUpdateContext\n");
	    if (!aglUpdateContext(SpGLContextArch(context).context)) {
		flag = SP_FALSE;
	    }
	    SpGLContextArch(context).prev_canvas_width = SpComponentPart(component).client_width;
	    SpGLContextArch(context).prev_canvas_height = SpComponentPart(component).client_height;

	    setGLCanvasClip(component, context);
	}
    }
    
    return flag;
}

spBool spGLCanvasPostRedrawArch(spComponent component)
{
    return SP_TRUE;
}

spBool spCreateGLVisualArch(spGLVisual visual, spTopLevel toplevel, spGLAttribute *attributes)
{
    SpGLVisualArch(visual).pixelformat
	= aglChoosePixelFormat(NULL, 0, attributes);

    if (SpGLVisualArch(visual).pixelformat == NULL) return SP_FALSE;
    
    return SP_TRUE;
}

spBool spDestroyGLVisualArch(spGLVisual visual)
{
    if (SpGLVisualArch(visual).pixelformat != NULL) {
	aglDestroyPixelFormat(SpGLVisualArch(visual).pixelformat);
	SpGLVisualArch(visual).pixelformat = NULL;
    }
    
    return SP_TRUE;
}

spBool spCreateGLContextArch(spGLContext context, spComponent gldrawable, spGLVisual visual, spGLContext share)
{
    AGLContext aglcshare = NULL;

    if (share != NULL) aglcshare = SpGLContextArch(share).context;
    
    SpGLContextArch(context).context
	= aglCreateContext(SpGLVisualArch(visual).pixelformat, aglcshare);

    if (SpGLContextArch(context).context == NULL) return SP_FALSE;

    SpGLContextArch(context).graphics = spCreateGraphics(NULL,
							 SppLineWidth, 1,
							 NULL);
    SpGLContextArch(context).prev_canvas_width = 0;
    SpGLContextArch(context).prev_canvas_height = 0;
    
    return SP_TRUE;
}

spBool spDestroyGLContextArch(spGLContext context)
{
    if (SpGLContextArch(context).context != NULL) {
	aglDestroyContext(SpGLContextArch(context).context);
	SpGLContextArch(context).context = NULL;
    }
    if (SpGLContextArch(context).graphics != NULL) {
	spFreeGraphics(SpGLContextArch(context).graphics);
    }
    
    return SP_TRUE;
}

spBool spSetGLContextArch(spComponent gldrawable, spGLContext context)
{
    spComponent window;

    if (context == NULL) {
	if (aglSetCurrentContext(NULL) == GL_TRUE) {
	    return SP_TRUE;
	}
    } else {
	window = SpGetWindow(gldrawable);
    
	if (aglSetDrawable(SpGLContextArch(context).context,
			   GetWindowPort(SpPrimitiveArch(window).window))) {
	    if (aglSetCurrentContext(SpGLContextArch(context).context)) {
		if (SpComponentPart(gldrawable).client_width != SpGLContextArch(context).prev_canvas_width
		    || SpComponentPart(gldrawable).client_height != SpGLContextArch(context).prev_canvas_height) {
		    SpGLContextArch(context).prev_canvas_width = SpComponentPart(gldrawable).client_width;
		    SpGLContextArch(context).prev_canvas_height = SpComponentPart(gldrawable).client_height;
		    setGLCanvasClip(gldrawable, context);
		}
		
		return SP_TRUE;
	    }
	}
    }

    return SP_FALSE;
}

spBool spGLSwapBuffersArch(spComponent gldrawable)
{
    spGLContext context;

    if ((context = SpGLCanvasPart(gldrawable).current_context) == NULL) {
	return SP_FALSE;
    }
    
    aglSwapBuffers(SpGLContextArch(context).context);
    
    return SP_TRUE;
}

spBool spGLWaitGLDrawingArch(spComponent gldrawable)
{
    glFinish();
    return SP_TRUE;
}

spBool spGLWaitSystemDrawingArch(spComponent gldrawable)
{
    return SP_TRUE;
}

char *spGetGLSystemExtensionListArch(spGLContext context)
{
    return "";
}

void *spGetGLProcAddressArch(char *proc)
{
#if defined(MACOSX)
    static void *image = NULL;
    char *symbolName;
    void *symbol = NULL;

    if (image == NULL) {
	image = dlopen("/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL", RTLD_LAZY);
    }

    if (image != NULL) {
	symbolName = xalloc(strlen(proc) + 2, char);
	strcpy(symbolName + 1, proc);
	symbolName[0] = '_';

	symbol = dlsym(image, symbolName);

	xfree(symbolName);
    }

    return symbol;
#else
    return NULL;
#endif
}

static void swapGLubyte(GLubyte *a, GLubyte *b)
{
    GLubyte tmp;

    tmp = *a;
    *a = *b;
    *b = tmp;
    
    return;
}

spBool spGLUseFontMac(spGraphics graphics, int first, int count, int list_base)
{
    FontInfo font_info;
    GWorldPtr font_gwp;
    GWorldPtr save_gwp;
    GDHandle save_gdh;
    Rect font_gwp_rect;
    Rect pixmap_rect;
    Rect font_rect;
    GLubyte *bitmap;
    GLint row_bytes;
    GLint width, height;
    GLint height2;
    GLint swapbytes;
    GLint lsbfirst;
    GLint rowlength;
    GLint skiprows;
    GLint skippixels;
    GLint alignment;
    int i, c;
    GLint m, n;
    unsigned char buf[8];
    int buflen;
    RGBColor black_rgb = {0, 0, 0};
    RGBColor white_rgb = {65535, 65535, 65535};
    spBool flag;
    
    spLockControlMutexMac();
    spLockDrawMutexMac();
    spLockPortMutexMac();
    
    spGetOriginalGWorldMac(&save_gwp, &save_gdh);
    spSetDummyGWorldMac();
    
    spSetFontMac(graphics);
    GetFontInfo(&font_info);

    font_gwp_rect.left = 0;
    font_gwp_rect.right = font_info.widMax;
    font_gwp_rect.top = -font_info.ascent;
    font_gwp_rect.bottom = font_info.descent;

    flag = SP_FALSE;
    
    font_gwp = NULL;
    if (NewGWorld(&font_gwp, 1, &font_gwp_rect, NULL, NULL, 0) == noErr) {
#if TARGET_API_MAC_CARBON
	LockPortBits(font_gwp);
#endif
	SetGWorld(font_gwp, NULL);
	if (LockPixels(GetGWorldPixMap(font_gwp))) {
	    bitmap = (GLubyte*)GetPixBaseAddr(GetGWorldPixMap(font_gwp));
#if TARGET_API_MAC_CARBON
	    GetPixBounds(GetGWorldPixMap(font_gwp), &pixmap_rect);
#else
	    pixmap_rect = font_gwp->portRect;
#endif
	    height = pixmap_rect.bottom - pixmap_rect.top;
	    row_bytes = ((**GetGWorldPixMap(font_gwp)).rowBytes & 0x3FFF);
	    
	    spSetFontMac(graphics);

	    RGBForeColor(&black_rgb);
	    RGBBackColor(&white_rgb);
    
	    /* get old integers */
	    glGetIntegerv(GL_UNPACK_SWAP_BYTES, &swapbytes);
	    glGetIntegerv(GL_UNPACK_LSB_FIRST, &lsbfirst);
	    glGetIntegerv(GL_UNPACK_SKIP_ROWS, &skiprows);
	    glGetIntegerv(GL_UNPACK_SKIP_PIXELS, &skippixels);
	    glGetIntegerv(GL_UNPACK_ALIGNMENT, &alignment);
	    glGetIntegerv(GL_UNPACK_ROW_LENGTH, &rowlength);
	    
	    /* update integers */
	    glPixelStorei(GL_UNPACK_SWAP_BYTES, GL_FALSE);
	    glPixelStorei(GL_UNPACK_LSB_FIRST, GL_FALSE);
	    glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
	    glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);
	    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	    glPixelStorei(GL_UNPACK_ROW_LENGTH, row_bytes * 8);

	    font_rect = font_gwp_rect;
	    height2 = height / 2;

	    for (i = 0; i < count; i++) {
		MoveTo(0, 0);

		c = first + i;
		spDebug(100, "spGLUseFontMac", "i = %d, c = %x (%d)\n", i, c, c); 
		
		if (c >= 256) {
		    buflen = 2;
		    buf[0] = (unsigned char)((c & 0xff00) >> 8);
		    buf[1] = (unsigned char)(c & 0xff);
		    buf[2] = '\0';
		    spDebug(100, "spGLUseFontMac", "pc = %x (%d), c = %x (%d)\n", buf[0], buf[0], buf[1], buf[1]); 
		} else {
		    buflen = 1;
		    buf[0] = (unsigned char)c;
		    buf[1] = '\0';
		}

		width = TextWidth(buf, 0, buflen);
		font_rect.right = font_rect.left + width;
		EraseRect(&font_rect);

		DrawText(buf, 0, buflen);

		for (m = 0; m < height2; m++) {
		    for (n = 0; n < row_bytes; n++) {
			swapGLubyte(&bitmap[m * row_bytes + n], &bitmap[(height - 1 - m) * row_bytes + n]);
		    }
		}
		
		glNewList(list_base + i, GL_COMPILE);
		glBitmap(width, height, 0, pixmap_rect.bottom, width, 0.0, bitmap);
		glEndList();
	    }

	    /* restore integers */
	    glPixelStorei(GL_UNPACK_SWAP_BYTES, swapbytes);
	    glPixelStorei(GL_UNPACK_LSB_FIRST, lsbfirst);
	    glPixelStorei(GL_UNPACK_SKIP_ROWS, skiprows);
	    glPixelStorei(GL_UNPACK_SKIP_PIXELS, skippixels);
	    glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
	    glPixelStorei(GL_UNPACK_ROW_LENGTH, rowlength);
	
	    UnlockPixels(GetGWorldPixMap(font_gwp));

	    flag = SP_TRUE;
	}
	
#if TARGET_API_MAC_CARBON
	UnlockPortBits(font_gwp);
#endif
    }

    SetGWorld(save_gwp, save_gdh);

    if (font_gwp != NULL) {
	DisposeGWorld(font_gwp);
    }
    
    spUnlockPortMutexMac();
    spUnlockDrawMutexMac();
    spUnlockControlMutexMac();

    return SP_TRUE;
}

spBool spGLUseFontArch(spComponent gldrawable, char *font_name, int first, int count, int list_base)
{
    spGLContext context;

    if ((context = SpGLCanvasPart(gldrawable).current_context) == NULL) {
	return SP_FALSE;
    }

    spSetGraphicsParams(SpGLContextArch(context).graphics,
			SppFontName, font_name,
			NULL);

    return spGLUseFontMac(SpGLContextArch(context).graphics, first, count, list_base);
}
