#include <sp/spOption.h>
#include <sp/spComponent.h>
#include <sp/spCanvasP.h>
#include <sp/spGraphicsP.h>
#include <sp/spDrawP.h>

#include <sp/spGLP.h>
#include <sp/spGLShaderP.h>

spBool spGLCanvasCreateArch(spComponent component)
{
    spCanvasCreateArch(component);
    return SP_TRUE;
}

spBool spGLCanvasSetParamsArch(spComponent component)
{
    return SP_TRUE;
}
    
spBool spGLCanvasDestroyArch(spComponent component)
{
    spCanvasDestroyArch(component);
    spPrimitiveDestroyArch(component);
    return SP_TRUE;
}

spBool spGLCanvasRedrawArch(spComponent component)
{
    if (SpPrimitiveArch(component).message == WM_PAINT) {
	PAINTSTRUCT paintstruct;
	
	spBeginPaintWin(component, &paintstruct);
	spEndPaintWin(component, &paintstruct);
    }
    
    if (SpGLCanvasPart(component).current_context != NULL) {
	return spSetGLContextArch(component, SpGLCanvasPart(component).current_context);
    }
    
    return SP_TRUE;
}

spBool spGLCanvasPostRedrawArch(spComponent component)
{
    return SP_TRUE;
}

spBool spCreateGLVisualArch(spGLVisual visual, spTopLevel toplevel, spGLAttribute *attributes)
{
    int i;
    PIXELFORMATDESCRIPTOR *ppfd;

    SpGLVisualArch(visual).core_attribs = NULL;
    SpGLVisualArch(visual).context_attribs = NULL;
    
    ppfd = &SpGLVisualArch(visual).pfd;

    memset(ppfd, 0, sizeof(PIXELFORMATDESCRIPTOR));
    ppfd->nSize = sizeof(PIXELFORMATDESCRIPTOR); 
    ppfd->nVersion = 1; 
    ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | 0x00008000/*PFD_SUPPORT_GDI*/;
    ppfd->dwLayerMask = PFD_MAIN_PLANE; 
    ppfd->iPixelType = PFD_TYPE_RGBA; 
    ppfd->cColorBits = 0; 
    ppfd->cDepthBits = 0; 
    ppfd->cAlphaBits = 0; 
    ppfd->cAccumBits = 0; 
    ppfd->cStencilBits = 0; 
    
    for (i = 0; attributes[i] != SP_GL_NONE; i++) {
	switch (attributes[i]) {
	  case SP_GL_USE_GL:
	    break;
	  case SP_GL_RGBA:
	    ppfd->iPixelType = PFD_TYPE_RGBA; 
	    break;
	  case SP_GL_DOUBLEBUFFER:
	    ppfd->dwFlags |= PFD_DOUBLEBUFFER;
	    break;
	  case SP_GL_STEREO:
	    ppfd->dwFlags |= PFD_STEREO;
	    break;

	  case SP_GL_LEVEL:
	  case SP_GL_BUFFER_SIZE:
	    i++;
	    break;
	  case SP_GL_ALPHA_SIZE:
	    i++;
	    ppfd->cAlphaBits = MAX(attributes[i], ppfd->cAlphaBits); 
	    break;
	  case SP_GL_ACCUM_RED_SIZE:
	  case SP_GL_ACCUM_GREEN_SIZE:
	  case SP_GL_ACCUM_BLUE_SIZE:
	  case SP_GL_ACCUM_ALPHA_SIZE:
	    i++;
	    ppfd->cAccumBits = MAX(attributes[i], ppfd->cAccumBits); 
	    break;
	  case SP_GL_STENCIL_SIZE:
	    i++;
	    ppfd->cStencilBits = MAX(attributes[i], ppfd->cStencilBits); 
	    break;
	    
	  case SP_GL_AUX_BUFFERS:
	    i++;
	    ppfd->cAuxBuffers = MAX(attributes[i], ppfd->cAuxBuffers); 
	    break;
	    
	  case SP_GL_RED_SIZE:
	  case SP_GL_GREEN_SIZE:
	  case SP_GL_BLUE_SIZE:
	    i++;
	    ppfd->cColorBits = MAX(attributes[i], ppfd->cColorBits); 
	    break;
	    
	  case SP_GL_DEPTH_SIZE:
	    i++;
	    ppfd->cDepthBits = MAX(attributes[i], ppfd->cDepthBits); 
	    break;
	}
    }

    SpGLVisualArch(visual).core_attribs = xspExtractGLAttributes(attributes, 1003, SP_FALSE, SP_GL_ATTRIBUTE_TYPE_CORE_MASK, NULL);
    SpGLVisualArch(visual).context_attribs = xspExtractGLAttributes(attributes, 1004, SP_FALSE, SP_GL_ATTRIBUTE_TYPE_CONTEXT_MASK, NULL);
    
    return SP_TRUE;
}

spBool spDestroyGLVisualArch(spGLVisual visual)
{
    if (SpGLVisualArch(visual).core_attribs != NULL) {
	xfree(SpGLVisualArch(visual).core_attribs);
	SpGLVisualArch(visual).core_attribs = NULL;
    }
    if (SpGLVisualArch(visual).context_attribs != NULL) {
	xfree(SpGLVisualArch(visual).context_attribs);
	SpGLVisualArch(visual).context_attribs = NULL;
    }
    
    return SP_TRUE;
}

static BOOL setupPixelFormat(HDC hdc, PIXELFORMATDESCRIPTOR *ppfd) 
{ 
    int pixelformat; 
 
    if ((pixelformat = ChoosePixelFormat(hdc, ppfd)) == 0) {
        spDebug(1, "setupPixelFormat", "ChoosePixelFormat failed.\n"); 
	return FALSE;
    }
    if (SetPixelFormat(hdc, pixelformat, ppfd) == FALSE) { 
        spDebug(1, "setupPixelFormat", "SetPixelFormat failed.\n"); 
        return FALSE; 
    } 
 
    return TRUE; 
} 

spBool spCreateGLContextArch(spGLContext context, spComponent gldrawable, spGLVisual visual, spGLContext share)
{
    HDC hdc;
    spBool flag = SP_TRUE;
    spBool context_renewed = SP_FALSE;

    SpGLContextArch(context).hglrc = NULL;
    SpGLContextArch(context).graphics = NULL;
    SpGLContextArch(context).ext_list = NULL;
    
    if (SpPrimitiveArch(gldrawable).hwnd == NULL) {
	return SP_FALSE;
    }

    hdc = GetDC(SpPrimitiveArch(gldrawable).hwnd);
    if (!setupPixelFormat(hdc, &SpGLVisualArch(visual).pfd)) {
	ReleaseDC(SpPrimitiveArch(gldrawable).hwnd, hdc);
	spDebug(10, "spCreateGLContextArch", "setupPixelFormat failed\n");
	return SP_FALSE;
    }

    SpGLContextArch(context).hglrc = wglCreateContext(hdc);
    spDebug(50, "spCreateGLContextArch", "hdc = %ld, hglrc = %ld\n", (long)hdc, (long)SpGLContextArch(context).hglrc); 

    if (SpGLContextArch(context).hglrc == NULL) {
	flag = SP_FALSE;
    } else {
	HDC hdcold;
	HGLRC hglrcold, hglrcnew;
	
	flag = SP_TRUE;
	
	hdcold = wglGetCurrentDC();
	hglrcold = wglGetCurrentContext();
	spDebug(50, "spCreateGLContextArch", "hdcold = %ld, hglrcold = %ld\n", (long)hdcold, (long)hglrcold); 

	if (hglrcold != SpGLContextArch(context).hglrc) {
	    /* for wglGetProcAddress */
	    spDebug(80, "spCreateGLContextArch", "call wglMakeCurrent\n"); 
	    wglMakeCurrent(hdc, SpGLContextArch(context).hglrc);
	}

	{
	    sp_wglGetExtensionsStringARBProc sp_wglGetExtensionsStringARB = NULL;
	    sp_wglGetExtensionsStringEXTProc sp_wglGetExtensionsStringEXT = NULL;

	    if ((sp_wglGetExtensionsStringARB = (sp_wglGetExtensionsStringARBProc)wglGetProcAddress("wglGetExtensionsStringARB")) != NULL) {
		SpGLContextArch(context).ext_list = (char *)sp_wglGetExtensionsStringARB(hdc);
	    } else if ((sp_wglGetExtensionsStringEXT = (sp_wglGetExtensionsStringEXTProc)wglGetProcAddress("wglGetExtensionsStringEXT")) != NULL) {
		SpGLContextArch(context).ext_list = (char *)sp_wglGetExtensionsStringEXT();
	    } else {
		SpGLContextArch(context).ext_list = "";
	    }

#if 0
	    fprintf(spgetstderr(), "extension = %s\n", SpGLContextArch(context).ext_list);
#endif
	}
	

	if ((SpGLVisualArch(visual).context_attribs != NULL || SpGLVisualArch(visual).core_attribs != NULL)
	    && spIsGLExtensionIncludedInList(SpGLContextArch(context).ext_list, "WGL_ARB_create_context")) {
	    HGLRC hglrcshare = NULL;
	    sp_wglCreateContextAttribsARBProc sp_wglCreateContextAttribsARB = NULL;

	    sp_wglCreateContextAttribsARB = (sp_wglCreateContextAttribsARBProc)wglGetProcAddress("wglCreateContextAttribsARB");
	    spDebug(50, "spCreateGLContextArch", "sp_wglCreateContextAttribsARB = %ld\n", (long)sp_wglCreateContextAttribsARB); 

	    if (sp_wglCreateContextAttribsARB != NULL) {
		if (SpGLVisualArch(visual).core_attribs != NULL
		    && spIsGLExtensionIncludedInList(SpGLContextArch(context).ext_list, "WGL_ARB_pixel_format")) {
		    int pixelformat;
		    UINT formatcount = 0;
		    
		    sp_wglChoosePixelFormatARBProc sp_wglChoosePixelFormatARB = NULL;
	    
		    sp_wglChoosePixelFormatARB = (sp_wglChoosePixelFormatARBProc)wglGetProcAddress("wglChoosePixelFormatARB");
		    if (sp_wglChoosePixelFormatARB != NULL) {
			if (sp_wglChoosePixelFormatARB(hdc, (const int *)SpGLVisualArch(visual).core_attribs, NULL,
						       1, &pixelformat, &formatcount) && formatcount >= 1) {
			    HWND hwnd;
			    spDebug(50, "spCreateGLContextArch", "pixelformat = %d, formatcount = %d\n", pixelformat, formatcount);
			    
			    wglMakeCurrent(NULL, NULL);
			    
			    if (SpGLContextArch(context).hglrc != NULL) {
				wglDeleteContext(SpGLContextArch(context).hglrc);
				SpGLContextArch(context).hglrc = NULL;
			    }
			    
			    ReleaseDC(SpPrimitiveArch(gldrawable).hwnd, hdc);
			    hdc = NULL;

			    /* destroy canvas */
			    spDebug(50, "spCreateGLContextArch", "call DestroyWindow\n");
			    hwnd = SpPrimitiveArch(gldrawable).hwnd;
			    SpPrimitiveArch(gldrawable).hwnd = NULL;
			    DestroyWindow(hwnd);

			    /* create canvas again */
			    spDebug(50, "spCreateGLContextArch", "call spCanvasCreateArch\n");
			    spCanvasCreateArch(gldrawable);

			    hdc = GetDC(SpPrimitiveArch(gldrawable).hwnd);
			    spDebug(50, "spCreateGLContextArch", "call SetPixelFormat\n");
			    if (!SetPixelFormat(hdc, pixelformat, &SpGLVisualArch(visual).pfd)) {
				spDebug(10, "spCreateGLContextArch", "SetPixelFormat error: %ld\n", (long)GetLastError());
				flag = SP_FALSE;
			    }
			} else {
			    spDebug(10, "spCreateGLContextArch", "wglChoosePixelFormatARB failed\n"); 
			}
		    }
		}

		spDebug(80, "spCreateGLContextArch", "flag = %d\n", flag);
		
		if (flag) {
		    if (share != NULL) {
			hglrcshare = SpGLContextArch(share).hglrc;
		    }
		
		    spDebug(80, "spCreateGLContextArch", "call wglCreateContextAttribsARB\n");
		    hglrcnew = sp_wglCreateContextAttribsARB(hdc, hglrcshare, SpGLVisualArch(visual).context_attribs);
		    spDebug(50, "spCreateGLContextArch", "hglrcnew = %ld\n", (long)hglrcnew); 
		
		    if (hglrcnew != NULL) {
			if (SpGLContextArch(context).hglrc != NULL) {
			    if (hglrcold != SpGLContextArch(context).hglrc) {
				wglMakeCurrent(NULL, NULL);
			    }
			    wglDeleteContext(SpGLContextArch(context).hglrc);
			} else {
			    hglrcold = hglrcnew;
			    hdcold = hdc;
			}
		    
			SpGLContextArch(context).hglrc = hglrcnew;
			wglMakeCurrent(hdc, SpGLContextArch(context).hglrc);
			
			context_renewed = SP_TRUE;
		    }
		}
	    }
	}
	    
	if (hglrcold != SpGLContextArch(context).hglrc) {
	    wglMakeCurrent(hdcold, hglrcold);
	}

	if (flag) {
	    if (context_renewed == SP_FALSE) {
		if (share != NULL) {
		    wglShareLists(SpGLContextArch(share).hglrc, SpGLContextArch(context).hglrc);
		}
	    }
	
	    SpGLContextArch(context).graphics = spCreateGraphics(NULL,
								 SppLineWidth, 1,
								 NULL);
	}
    }

    ReleaseDC(SpPrimitiveArch(gldrawable).hwnd, hdc);
    
    return flag;
}

spBool spDestroyGLContextArch(spGLContext context)
{
    BOOL flag;
    
    if (SpGLContextArch(context).hglrc != NULL) {
	flag = wglDeleteContext(SpGLContextArch(context).hglrc);
	SpGLContextArch(context).hglrc = NULL;
    }
    if (SpGLContextArch(context).graphics != NULL) {
	spFreeGraphics(SpGLContextArch(context).graphics);
    }

    if (flag) {
	return SP_FALSE;
    } else {
	return SP_TRUE;
    }
}

spBool spSetGLContextArch(spComponent gldrawable, spGLContext context)
{
    BOOL flag;
    HDC hdc;
    
    if (context == NULL) {
	flag = wglMakeCurrent(NULL, NULL);
    } else {
	hdc = GetDC(SpPrimitiveArch(gldrawable).hwnd);
	flag = wglMakeCurrent(hdc, SpGLContextArch(context).hglrc);
	ReleaseDC(SpPrimitiveArch(gldrawable).hwnd, hdc);
    }

    if (flag) {
	spDebug(50, "spSetGLContextArch", "successfully done\n");
	return SP_TRUE;
    } else {
	spDebug(10, "spSetGLContextArch", "wglMakeCurrent failed\n");
	return SP_FALSE;
    }
}

spBool spGLSwapBuffersArch(spComponent gldrawable)
{
    HDC hdc;
    BOOL flag;

    hdc = GetDC(SpPrimitiveArch(gldrawable).hwnd);
    flag = SwapBuffers(hdc);
    ReleaseDC(SpPrimitiveArch(gldrawable).hwnd, hdc);
    
    if (!flag) return SP_FALSE;
    
    return SP_TRUE;
}

spBool spGLWaitGLDrawingArch(spComponent gldrawable)
{
    glFinish();
    return SP_TRUE;
}

spBool spGLWaitSystemDrawingArch(spComponent gldrawable)
{
    GdiFlush();
    return SP_TRUE;
}

spBool spGLUseFontArch(spComponent gldrawable, char *font_name, int first, int count, int list_base)
{
    HDC hdc;
    LOGFONT lf;
    HFONT font, prev_font;
    BOOL success;

    hdc = GetDC(SpPrimitiveArch(gldrawable).hwnd);
    
    if (hdc == NULL) {
        spDebug(10, "spGLUseFontArch", "Error: GetDC\n"); 
	return SP_FALSE;
    }

    spFontNameToLOGFONT(font_name, &lf, SP_FALSE);

    if ((font = CreateFontIndirect(&lf)) == NULL) {
	success = FALSE;
        spDebug(10, "spGLUseFontArch", "Error: CreateFontIndirect for font %s\n", font_name); 
    } else {
	prev_font = SelectObject(hdc, font);
	success = wglUseFontBitmaps(hdc, first, count, list_base);
	spDebug(50, "spGLUseFontArch", "wglUseFontBitmaps result = %d, first = %d, count = %d, list_base = %d\n",
		success, first, count, list_base); 
		
	SelectObject(hdc, prev_font);

	DeleteObject(font);
    }
    
    ReleaseDC(SpPrimitiveArch(gldrawable).hwnd, hdc);
    
    if (success) {
	return SP_TRUE;
    } else {
	spDebug(50, "spGLUseFontArch", "wglUseFontBitmaps failed: code = %ld\n", GetLastError()); 
	return SP_FALSE;
    }
}
