/* Windows GDI+ related functions */
#include <windows.h>
#include <gdiplus.h>

#include <sp/spDefs.h>
#include <sp/spBase.h>
#include <sp/spMemory.h>

#include <sp/spGLP.h>

spBool spGetStringExtentWinGP(HDC hdc, HFONT hfont, WCHAR *wstr,
			      int *x, int *y, int *width, int *height, int *next_x)
{
    Gdiplus::Graphics graphics(hdc);
    Gdiplus::Font font(hdc, hfont);
    Gdiplus::FontFamily family;

    if (font.GetFamily(&family) != Gdiplus::Ok) {
	return SP_FALSE;
    }
    
    Gdiplus::PointF origin(0.0f, 0.0f);
    Gdiplus::RectF boundRect;

    graphics.MeasureString(wstr, -1, &font, origin, &boundRect);
    spDebug(50, "spGetStringExtentWinGP", "boundRect = %f, %f, %f, %f\n",
	    boundRect.X, boundRect.Y, boundRect.Width, boundRect.Height);

    Gdiplus::REAL lineHeight = font.GetHeight(&graphics);
    Gdiplus::REAL cellSpacing = (Gdiplus::REAL)family.GetLineSpacing(font.GetStyle());
    Gdiplus::REAL cellAscent = (Gdiplus::REAL)family.GetCellAscent(font.GetStyle());
    Gdiplus::REAL ascent = lineHeight * cellAscent / cellSpacing;
    spDebug(50, "spGetStringExtentWinGP", "lineHeight = %f, cellSpacing = %f, cellAscent = %f, ascent = %f\n",
	    lineHeight, cellSpacing, cellAscent, ascent);

    *x = (int)spRound(boundRect.X);
    *y = (int)spRound(boundRect.Y - ascent);
    *width = (int)spRound(boundRect.Width);
    *height = (int)spRound(boundRect.Height);
    *next_x = (int)spRound(boundRect.Width);

    return SP_TRUE;
}

spBool spDrawStringToBitmapDataWinGP(HDC hdc, HFONT hfont, DWORD fg_pixel, int topleft_x, int topleft_y,
				     int bitmap_width, int bitmap_height, int stride, BYTE *data, WCHAR *wstr)
{
    spDebug(50, "spDrawStringToBitmapDataWinGP", "topleft_x = %d, topleft_y = %d, bitmap_width = %d, bitmap_height = %d, stride = %d\n",
	    topleft_x, topleft_y, bitmap_width, bitmap_height, stride);
    
    Gdiplus::Bitmap bitmap(bitmap_width, bitmap_height, stride, PixelFormat32bppARGB, data);

    Gdiplus::Graphics* graphics = Gdiplus::Graphics::FromImage(&bitmap);

    Gdiplus::Font font(hdc, hfont);
    Gdiplus::PointF origin((Gdiplus::REAL)topleft_x, (Gdiplus::REAL)topleft_y);
    Gdiplus::SolidBrush brush(Gdiplus::Color((Gdiplus::ARGB)(0xff000000 | fg_pixel)));

    graphics->SetTextRenderingHint(Gdiplus::/*TextRenderingHintSingleBitPerPixel*/TextRenderingHintAntiAliasGridFit);
    
    graphics->DrawString(wstr, -1, &font, origin, &brush);

    delete graphics;
    
    return SP_TRUE;
}
