#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Frame.h>

#define SP_USE_GLW_MDRAWING_AREA_WIDGET
/* On cygwin, GLwDrawA with Xm (in resizing canvas) doesn't work correctly. */
#if defined(SP_USE_GLW_MDRAWING_AREA_WIDGET)
#include <GL/GLwMDrawA.h>
#else
#include <GL/GLwDrawA.h>
#endif

#include <sp/spComponent.h>
#include <sp/spCanvasP.h>
#include <sp/spGLP.h>

spBool spGLCanvasCreateArch(spComponent component)
{
    int narg = 0;
    int shadow_thickness = 0;
    Arg args[20];

    SpComponentPart(component).border_width = 0;
    
#ifndef LESSTIF_FRAME_BUG
    if (SpCanvasPart(component).border_on == SP_TRUE) {
	SpComponentPart(component).border_width = 2;
	shadow_thickness = 2;
        SpPrimitiveArch(component).top_widget =
            XtVaCreateManagedWidget("",
                                    xmFrameWidgetClass, SpParentPrimitiveArch(component).widget,
                                    XmNshadowType, XmSHADOW_IN,
                                    XmNshadowThickness, shadow_thickness,
                                    XmNmarginWidth, 0,
                                    XmNmarginHeight, 0,
                                    NULL);
    }
#endif

    XtSetArg(args[narg], GLwNrgba, True); narg++;
    XtSetArg(args[narg], GLwNvisualInfo,
	     SpGLVisualArch(SpGLCanvasPart(component).glvisual).visual_info); narg++;
    XtSetArg(args[narg], XmNmarginWidth, 0); narg++;
    XtSetArg(args[narg], XmNmarginHeight, 0); narg++;
    XtSetArg(args[narg], XmNresizePolicy, XmRESIZE_NONE); narg++;
    if (SpCanvasPart(component).focusable == SP_TRUE) {
	XtSetArg(args[narg], XmNtraversalOn, True); narg++;
    } else {
	XtSetArg(args[narg], XmNtraversalOn, False); narg++;
    }
    
    SpPrimitiveArch(component).widget =
	XtCreateManagedWidget((!strnone(SpGetName(component)) ? SpGetName(component) : ""),
#if defined(SP_USE_GLW_MDRAWING_AREA_WIDGET)
                              glwMDrawingAreaWidgetClass,
#else
			      glwDrawingAreaWidgetClass,
#endif
			      (SpPrimitiveArch(component).top_widget != NULL ?
			       SpPrimitiveArch(component).top_widget : SpParentPrimitiveArch(component).widget),
			      args, narg);
    
    spAddCallback(component, SP_RESIZE_CALLBACK, spResizeCanvasCB, NULL);
    spAddCallback(component, SP_KEY_PRESS_CALLBACK, spCanvasProcessTabKeyXmCB, NULL);

    return SP_TRUE;
}

spBool spGLCanvasSetParamsArch(spComponent component)
{
    return SP_TRUE;
}
    
spBool spGLCanvasDestroyArch(spComponent component)
{
    spRemoveCallback(component, SP_RESIZE_CALLBACK, spResizeCanvasCB, NULL);
    spPrimitiveDestroyArch(component);
    return SP_TRUE;
}

spBool spGLCanvasRedrawArch(spComponent component)
{
    spGLContext context;
    
    spDebug(10, "spGLCanvasRedrawArch", "in\n");
    
    if (SpGLCanvasPart(component).current_context != NULL) {
	context = SpGLCanvasPart(component).current_context;

	spDebug(10, "spGLCanvasRedrawArch", "call glXMakeCurrent\n");
	
	/* Resizing window causes truncated drawing and occasional crash without following code.
	 * OpenGL for X11 or Mesa problem? */
	if (!glXMakeCurrent(SpGLContextArch(context).display,
			    XtWindow(SpPrimitiveArch(component).widget),
			    SpGLContextArch(context).context)) {
	    spDebug(10, "spGLCanvasRedrawArch", "glXMakeCurrent failed\n");
	    return SP_FALSE;
	}
	
    }
    
    spDebug(10, "spGLCanvasRedrawArch", "done\n");
    
    return SP_TRUE;
}

spBool spGLCanvasPostRedrawArch(spComponent component)
{
    return SP_TRUE;
}

spBool spCheckGLXVersion(spGLVisual visual, int major, int minor)
{
    if (SpGLVisualArch(visual).glx_major_version > major
	|| (SpGLVisualArch(visual).glx_major_version == major
	    && SpGLVisualArch(visual).glx_minor_version >= minor)) {
	return SP_TRUE;
    } else {
	return SP_FALSE;
    }
}
spBool spCreateGLVisualArch(spGLVisual visual, spTopLevel toplevel, spGLAttribute *attributes)
{
    int count = 0;
    int fb_num_config = 0;
    GLXFBConfig *fb_configs = NULL;
    
    SpGLVisualArch(visual).glx_major_version = 0;
    SpGLVisualArch(visual).glx_minor_version = 0;
    SpGLVisualArch(visual).core_attributes = NULL;
    SpGLVisualArch(visual).context_attributes = NULL;
    SpGLVisualArch(visual).visual_info = NULL;
    SpGLVisualArch(visual).fb_num_config = 0;
    SpGLVisualArch(visual).fb_configs = NULL;
    
    if (!glXQueryExtension(SpTopLevelArch(toplevel).display, NULL, NULL)) {
        spDebug(1, "spCreateGLVisualArch", "GLX is not supported.\n");
	return SP_FALSE;
    }

    if (!glXQueryVersion(SpTopLevelArch(toplevel).display,
			 &SpGLVisualArch(visual).glx_major_version,
			 &SpGLVisualArch(visual).glx_minor_version)) {
        spDebug(1, "spCreateGLVisualArch", "glXQueryVersion failed.\n");
	return SP_FALSE;
    }
    spDebug(10, "spCreateGLVisualArch", "major = %d, minor = %d\n",
	    SpGLVisualArch(visual).glx_major_version, SpGLVisualArch(visual).glx_minor_version);

    if (spCheckGLXVersion(visual, 1, 3)) {
	SpGLVisualArch(visual).core_attributes = xspExtractGLAttributes(attributes, 1003, SP_FALSE, SP_GL_ATTRIBUTE_TYPE_CORE_MASK, &count);
        spDebug(10, "spCreateGLVisualArch", "core_attributes count = %d\n", count);

	fb_configs = glXChooseFBConfig(SpTopLevelArch(toplevel).display,
				       DefaultScreen(SpTopLevelArch(toplevel).display), SpGLVisualArch(visual).core_attributes,
				       &fb_num_config);
        spDebug(10, "spCreateGLVisualArch", "glXChooseFBConfig: fb_num_config = %d\n", fb_num_config);
    }

    if (fb_num_config > 0 && fb_configs != NULL) {
	SpGLVisualArch(visual).fb_num_config = fb_num_config;
	SpGLVisualArch(visual).fb_configs = fb_configs;

#if 0
	{
	    int i, j, k;
	    int value;

	    for (i = 0; i < fb_num_config; i++) {
		for (j = 1; j <= 19; j++) {
		    if (j <= 17) {
			k = j;
		    } else {
			k = j - 18 + 100000;
		    }
		    if (glXGetFBConfigAttrib(SpTopLevelArch(toplevel).display, fb_configs[i],
					     k,  &value) == Success) {
			printf("%d: attribute 0x%x = %d\n", i, k, value);
		    }
		}
	    }
	}
#endif

	SpGLVisualArch(visual).visual_info = glXGetVisualFromFBConfig(SpTopLevelArch(toplevel).display, *fb_configs);

	if (spCheckGLXVersion(visual, 1, 4)) {
	    SpGLVisualArch(visual).context_attributes = xspExtractGLAttributes(attributes, 1004, SP_FALSE, SP_GL_ATTRIBUTE_TYPE_CONTEXT_MASK, &count);
	    spDebug(10, "spCreateGLVisualArch", "context_attributes count = %d\n", count);
	}
    } else {
	if (SpGLVisualArch(visual).core_attributes != NULL) xfree(SpGLVisualArch(visual).core_attributes);
	
	SpGLVisualArch(visual).core_attributes = xspExtractGLAttributes(attributes, 1000, SP_TRUE, SP_GL_ATTRIBUTE_TYPE_CORE_MASK, &count);
	spDebug(10, "spCreateGLVisualArch", "context_attributes count = %d\n", count);
	
	SpGLVisualArch(visual).visual_info = glXChooseVisual(SpTopLevelArch(toplevel).display,
							     DefaultScreen(SpTopLevelArch(toplevel).display),
							     SpGLVisualArch(visual).core_attributes);
    }
    
    if (SpGLVisualArch(visual).visual_info == NULL) { 
        spDebug(1, "spCreateGLVisualArch", "Could not get visual.\n");
	return SP_FALSE;
    } 

    return SP_TRUE;
}

spBool spDestroyGLVisualArch(spGLVisual visual)
{
    if (SpGLVisualArch(visual).visual_info != NULL) { 
	XFree(SpGLVisualArch(visual).visual_info);
	SpGLVisualArch(visual).visual_info = NULL;
    }
    if (SpGLVisualArch(visual).fb_configs != NULL) {
	XFree(SpGLVisualArch(visual).fb_configs);
	SpGLVisualArch(visual).fb_configs = NULL;
    }
    if (SpGLVisualArch(visual).core_attributes != NULL) {
	xfree(SpGLVisualArch(visual).core_attributes);
	SpGLVisualArch(visual).core_attributes = NULL;
    }
    if (SpGLVisualArch(visual).context_attributes != NULL) {
	xfree(SpGLVisualArch(visual).context_attributes);
	SpGLVisualArch(visual).context_attributes = NULL;
    }
    
    return SP_TRUE;
}

typedef GLXContext (*sp_glXCreateContextAttribsARBProc)(Display*, GLXFBConfig, GLXContext, Bool, const int *);

static Bool sp_glx_context_error = False;
static int spGLXContextErrorHandler(Display *dpy, XErrorEvent *ev)
{
    sp_glx_context_error = True;
    return 0;
}

spBool spCreateGLContextArch(spGLContext context, spComponent gldrawable, spGLVisual visual, spGLContext share)
{
    int i;
    char *exts;
    Display *display = NULL;
    GLXContext glxcshare = NULL;
    GLXContext glxcontext = NULL;
    spBool do_sync;
    int (*old_handler)(Display *, XErrorEvent *) = NULL;
    
    if (share != NULL) glxcshare = SpGLContextArch(share).context;
    
    SpGLContextArch(context).display = NULL;
    display = XtDisplay(SpPrimitiveArch(gldrawable).widget);
    
    exts = (char *)glXGetClientString(display, GLX_EXTENSIONS);
#if 0
    fprintf(spgetstderr(), "exts = %s\n", exts);
#endif
    
    old_handler = XSetErrorHandler(&spGLXContextErrorHandler);

    if (SpGLVisualArch(visual).fb_configs != NULL) {
	i = 0;
    } else {
	i = 2;
    }
    
    for (; i < 3; i++) {
	sp_glx_context_error = False;
	do_sync = SP_FALSE;
	
	if (i == 0) {
	    sp_glXCreateContextAttribsARBProc sp_glXCreateContextAttribsARB = NULL;

	    if (SpGLVisualArch(visual).fb_configs != NULL
		&& spIsGLExtensionIncludedInList(exts, "GLX_ARB_create_context")
		&& (sp_glXCreateContextAttribsARB = (sp_glXCreateContextAttribsARBProc)spGetGLProcAddress("glXCreateContextAttribsARB")) != NULL) {
		
		spDebug(50, "spCreateGLContextArch", "call glXCreateContextAttribsARB\n");
		glxcontext = sp_glXCreateContextAttribsARB(display, *SpGLVisualArch(visual).fb_configs,
                                                           glxcshare, True,
							   SpGLVisualArch(visual).context_attributes);
		do_sync = SP_TRUE;
	    }
	} else if (i == 1) {
	    if (SpGLVisualArch(visual).fb_configs != NULL) {
		glxcontext = glXCreateNewContext(display, *SpGLVisualArch(visual).fb_configs, GLX_RGBA_TYPE, glxcshare, True);
		do_sync = SP_TRUE;
	    }
	} else {
	    glxcontext = glXCreateContext(display, SpGLVisualArch(visual).visual_info, glxcshare, True);
	    do_sync = SP_TRUE;
	}

        spDebug(50, "spCreateGLContextArch", "i = %d, glxcontext = %ld, do_sync = %d\n", i, (long)glxcontext, do_sync);
	
	if (do_sync) {
	    XSync(display, False);
	}

	if (glxcontext != NULL && !sp_glx_context_error) {
	    break;
	}
    }

    XSetErrorHandler(old_handler);
    
    if (glxcontext == NULL || sp_glx_context_error) {
        spDebug(10, "spCreateGLContextArch", "failed\n");
	return SP_FALSE;
    }

    SpGLContextArch(context).context = glxcontext;
    SpGLContextArch(context).display = display;

    SpGLContextArch(context).ext_list = (char *)glXQueryExtensionsString(display, DefaultScreen(display));
#if 0
    fprintf(spgetstderr(), "ext_list = %s\n", SpGLContextArch(context).ext_list);
#endif
 
    return SP_TRUE;
}

spBool spDestroyGLContextArch(spGLContext context)
{
    if (SpGLContextArch(context).context != NULL) {
	glXDestroyContext(SpGLContextArch(context).display,
			  SpGLContextArch(context).context);
    }
    
    return SP_TRUE;
}

spBool spSetGLContextArch(spComponent gldrawable, spGLContext context)
{
    if (context == NULL) {
	if (glXMakeCurrent(XtDisplay(SpPrimitiveArch(gldrawable).widget),
			   None, NULL)) {
	    return SP_TRUE;
	}
    } else {
	if (glXMakeCurrent(SpGLContextArch(context).display,
			   XtWindow(SpPrimitiveArch(gldrawable).widget),
			   SpGLContextArch(context).context)) {
	    return SP_TRUE;
	}
    }

    return SP_FALSE;
}

spBool spGLSwapBuffersArch(spComponent gldrawable)
{
    glXSwapBuffers(XtDisplay(SpPrimitiveArch(gldrawable).widget),
		   XtWindow(SpPrimitiveArch(gldrawable).widget));
    
    return SP_TRUE;
}

spBool spGLWaitGLDrawingArch(spComponent gldrawable)
{
    glXWaitGL();
    return SP_TRUE;
}

spBool spGLWaitSystemDrawingArch(spComponent gldrawable)
{
    glXWaitX();
    return SP_TRUE;
}

spBool spGLUseFontArch(spComponent gldrawable, char *font_name, int first, int count, int list_base)
{
    XFontStruct *font_info;
    Display *display;

    if ((display = glXGetCurrentDisplay()) == NULL) return SP_FALSE;

    font_info = XLoadQueryFont(display, font_name);
    if (!font_info) {
        spDebug(10, "spGLUseFontArch", "Font %s not found\n", font_name);
	return SP_FALSE;
    }
    glXUseXFont(font_info->fid, first, count, list_base);

    return SP_TRUE;
}
